/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichPageContent;
import me.chrr.scribble.book.RichSelectionManager;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.book.SynchronizedPageList;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.ColorSwatchWidget;
import me.chrr.scribble.gui.IconButtonWidget;
import me.chrr.scribble.gui.ModifierButtonWidget;
import me.chrr.scribble.history.BookEditScreenMemento;
import me.chrr.scribble.history.CommandManager;
import me.chrr.scribble.history.Restorable;
import me.chrr.scribble.history.command.ActionCommand;
import me.chrr.scribble.history.command.DeletePageCommand;
import me.chrr.scribble.history.command.InsertPageCommand;
import me.chrr.scribble.history.command.PagesListener;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3728;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_473;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_9301;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_473.class})
public abstract class BookEditScreenMixin
extends class_437
implements PagesListener,
Restorable<BookEditScreenMemento> {
    @Unique
    private static final int MAX_PAGES_NUMBER = 100;
    @Unique
    private static final class_124[] COLORS = new class_124[]{class_124.field_1074, class_124.field_1063, class_124.field_1080, class_124.field_1068, class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1077, class_124.field_1060, class_124.field_1062, class_124.field_1075, class_124.field_1058, class_124.field_1078, class_124.field_1064, class_124.field_1076};
    @Unique
    private static final class_124 DEFAULT_COLOR = class_124.field_1074;
    @Mutable
    @Shadow
    @Final
    private class_3728 field_24269;
    @Shadow
    private int field_2840;
    @Shadow
    private boolean field_2837;
    @Shadow
    @Final
    private List<String> field_17116;
    @Shadow
    private boolean field_2828;
    @Shadow
    @Final
    private class_1657 field_2826;
    @Unique
    private final SynchronizedPageList synchronizedPages = new SynchronizedPageList();
    @Unique
    private final CommandManager commandManager;
    @Unique
    @Nullable
    private class_124 activeColor;
    @Unique
    @NotNull
    private Set<class_124> activeModifiers;
    @Unique
    private ModifierButtonWidget boldButton;
    @Unique
    private ModifierButtonWidget italicButton;
    @Unique
    private ModifierButtonWidget underlineButton;
    @Unique
    private ModifierButtonWidget strikethroughButton;
    @Unique
    private ModifierButtonWidget obfuscatedButton;
    @Unique
    @NotNull
    private List<ColorSwatchWidget> colorSwatches;
    @Unique
    private IconButtonWidget deletePageButton;
    @Unique
    private IconButtonWidget insertPageButton;
    @Unique
    private IconButtonWidget undoButton;
    @Unique
    private IconButtonWidget redoButton;
    @Unique
    private IconButtonWidget saveBookButton;
    @Unique
    private IconButtonWidget loadBookButton;

    @Shadow
    protected abstract class_473.class_5234 method_27590(class_473.class_5234 var1);

    @Shadow
    static int method_27591(int[] lineStarts, int position) {
        return 0;
    }

    @Shadow
    protected abstract class_768 method_27583(class_473.class_5234 var1, class_473.class_5234 var2);

    @Shadow
    protected abstract void method_27584(String var1);

    @Shadow
    protected abstract void method_27577();

    @Shadow
    protected abstract void method_27872();

    @Shadow
    protected abstract void method_2413();

    private BookEditScreenMixin() {
        super(null);
        this.commandManager = new CommandManager(Scribble.CONFIG_MANAGER.getConfig().editHistorySize);
        this.activeColor = DEFAULT_COLOR;
        this.activeModifiers = new HashSet<class_124>();
        this.colorSwatches = List.of();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void init(class_1657 player, class_1799 stack, class_1268 hand, class_9301 writableBookContent, CallbackInfo ci) {
        this.field_24269 = new RichSelectionManager(this::getCurrentPageText, this::setPageText, this::onCursorFormattingChanged, this::getRawClipboard, this::method_27584, text -> text.getAsFormattedString().length() < 1024 && this.field_22793.method_44378((class_5348)text, 114) <= 128, () -> Optional.ofNullable(this.activeColor).orElse(DEFAULT_COLOR), () -> this.activeModifiers);
        this.commandManager.onHistoryUpdate(this::invalidateHistoryButtons);
        this.synchronizedPages.populate(this.field_17116);
        this.getRichSelectionManager().notifyCursorFormattingChanged();
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    private void initScreen(CallbackInfo ci) {
        this.initButtons();
    }

    @Unique
    private void initButtons() {
        int x = this.field_22789 / 2 + 78;
        int y = Scribble.getBookScreenYOffset(this.field_22790) + 12;
        this.boldButton = this.addModifierButton(class_124.field_1067, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.bold"), x, y, 0, 0, 22, 19);
        this.italicButton = this.addModifierButton(class_124.field_1056, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.italic"), x, y + 19, 0, 19, 22, 17);
        this.underlineButton = this.addModifierButton(class_124.field_1073, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.underline"), x, y + 36, 0, 36, 22, 17);
        this.strikethroughButton = this.addModifierButton(class_124.field_1055, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.strikethrough"), x, y + 53, 0, 53, 22, 17);
        this.obfuscatedButton = this.addModifierButton(class_124.field_1051, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.obfuscated"), x, y + 70, 0, 70, 22, 18);
        this.colorSwatches = new ArrayList<ColorSwatchWidget>(COLORS.length);
        for (int i = 0; i < COLORS.length; ++i) {
            class_124 color = COLORS[i];
            int dx = i % 2 * 8;
            int dy = i / 2 * 8;
            ColorSwatchWidget swatch = new ColorSwatchWidget((class_2561)class_2561.method_43471((String)("text.scribble.color." + color.method_537())), color, () -> this.changeActiveColor(color), x + 3 + dx, y + 95 + dy, 8, 8);
            swatch.setToggled(this.activeColor == color);
            ColorSwatchWidget widget = (ColorSwatchWidget)this.method_37063((class_364)swatch);
            this.colorSwatches.add(widget);
        }
        int px = this.field_22789 / 2 - 96;
        this.deletePageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.delete_page"), this::deletePage, px + 78, y + 148, 0, 90, 12, 12));
        this.insertPageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.insert_new_page"), this::insertPage, px + 94, y + 148, 12, 90, 12, 12));
        int ax = this.field_22789 / 2 - 78 - 7 - 12;
        int ay = y + 4;
        this.undoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.undo"), this.commandManager::tryUndo, ax, ay, 24, 90, 12, 12));
        this.redoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.redo"), this.commandManager::tryRedo, ax, ay + 12, 36, 90, 12, 12));
        this.saveBookButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.save_book_to_file"), () -> FileChooser.chooseBook(true, this::saveTo), ax, ay + 24 + 4, 48, 90, 12, 12));
        this.loadBookButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.load_book_from_file"), () -> this.confirmOverwrite(() -> FileChooser.chooseBook(false, this::loadFrom)), ax, ay + 36 + 4, 60, 90, 12, 12));
        this.invalidateHistoryButtons();
    }

    @Unique
    private ModifierButtonWidget addModifierButton(class_124 modifier, class_2561 tooltip, int x, int y, int u, int v, int width, int height) {
        ModifierButtonWidget button = new ModifierButtonWidget(tooltip, toggled -> this.toggleActiveModifier(modifier, (boolean)toggled), x, y, u, v, width, height, this.activeModifiers.contains(modifier));
        return (ModifierButtonWidget)this.method_37063((class_364)button);
    }

    @Unique
    private void changeActiveColor(@NotNull class_124 newColor) {
        if (newColor == this.activeColor) {
            return;
        }
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> {
            this.activeColor = newColor;
            this.invalidateFormattingButtons();
            this.getRichSelectionManager().applyColorForSelection(newColor);
        });
        this.commandManager.execute(command);
    }

    @Unique
    public void toggleActiveModifier(class_124 modifier, boolean toggled) {
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> {
            if (toggled) {
                this.activeModifiers.add(modifier);
            } else {
                this.activeModifiers.remove(modifier);
            }
            this.invalidateFormattingButtons();
            this.getRichSelectionManager().toggleModifierForSelection(modifier, toggled);
        });
        this.commandManager.execute(command);
    }

    @Inject(method={"updateButtons"}, at={@At(value="HEAD")})
    private void invalidateControlButtons(CallbackInfo ci) {
        Optional.ofNullable(this.boldButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828;
        });
        Optional.ofNullable(this.italicButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828;
        });
        Optional.ofNullable(this.underlineButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828;
        });
        Optional.ofNullable(this.strikethroughButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828;
        });
        Optional.ofNullable(this.obfuscatedButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828;
        });
        for (ColorSwatchWidget swatch : this.colorSwatches) {
            swatch.field_22764 = !this.field_2828;
        }
        Optional.ofNullable(this.deletePageButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && this.synchronizedPages.size() > 1;
        });
        Optional.ofNullable(this.insertPageButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && this.synchronizedPages.size() < 100;
        });
        boolean showSaveLoadButtons = Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER;
        Optional.ofNullable(this.undoButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && showSaveLoadButtons;
        });
        Optional.ofNullable(this.redoButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && showSaveLoadButtons;
        });
        Optional.ofNullable(this.saveBookButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && showSaveLoadButtons;
        });
        Optional.ofNullable(this.loadBookButton).ifPresent(button -> {
            button.field_22764 = !this.field_2828 && showSaveLoadButtons;
        });
    }

    @Unique
    private void invalidateFormattingButtons() {
        Optional.ofNullable(this.boldButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(class_124.field_1067);
        });
        Optional.ofNullable(this.italicButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(class_124.field_1056);
        });
        Optional.ofNullable(this.underlineButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(class_124.field_1073);
        });
        Optional.ofNullable(this.strikethroughButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(class_124.field_1055);
        });
        Optional.ofNullable(this.obfuscatedButton).ifPresent(button -> {
            button.toggled = this.activeModifiers.contains(class_124.field_1051);
        });
        this.setSwatchColor(this.activeColor);
    }

    @Unique
    private void invalidateHistoryButtons() {
        Optional.ofNullable(this.undoButton).ifPresent(button -> {
            button.field_22763 = this.commandManager.hasCommandsToUndo();
        });
        Optional.ofNullable(this.redoButton).ifPresent(button -> {
            button.field_22763 = this.commandManager.hasCommandsToRedo();
        });
    }

    @Unique
    private void setSwatchColor(class_124 color) {
        for (ColorSwatchWidget swatch : this.colorSwatches) {
            swatch.setToggled(swatch.getColor() == color);
        }
    }

    @Unique
    private void onCursorFormattingChanged(@Nullable class_124 color, Set<class_124> modifiers) {
        this.activeColor = color;
        this.activeModifiers = modifiers;
        this.invalidateFormattingButtons();
    }

    @Redirect(method={"getCurrentPageContent"}, at=@At(value="INVOKE", target="Ljava/util/List;get(I)Ljava/lang/Object;"))
    public Object getCurrentPageContent(List<String> pages, int page) {
        return this.synchronizedPages.get(page).getPlainText();
    }

    @Overwrite
    public void method_2439(String newContent) {
        Scribble.LOGGER.warn("setPageContent() was called, but ignored.");
    }

    @Unique
    private String getRawClipboard() {
        return this.field_22787 != null ? this.field_22787.field_1774.method_1460().replaceAll("\\r", "") : "";
    }

    @Unique
    private class_768 getSelectionRectangle(RichText text, class_5225 handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        RichText toSelectionStart = text.subText(lineStart, selectionStart);
        RichText toSelectionEnd = text.subText(lineStart, selectionEnd);
        class_473.class_5234 topLeft = new class_473.class_5234((int)handler.method_27488((class_5348)toSelectionStart), lineY);
        class_473.class_5234 bottomRight = new class_473.class_5234((int)handler.method_27488((class_5348)toSelectionEnd), lineY + 9);
        return this.method_27583(topLeft, bottomRight);
    }

    @Unique
    private RichText getCurrentPageText() {
        return this.field_2840 >= 0 && this.field_2840 < this.synchronizedPages.size() ? this.synchronizedPages.get(this.field_2840) : RichText.empty();
    }

    @Unique
    private void setPageText(RichText newText) {
        if (this.field_2840 >= 0 && this.field_2840 < this.synchronizedPages.size()) {
            this.synchronizedPages.set(this.field_2840, newText);
        }
        this.field_2837 = true;
        this.method_27577();
    }

    @Unique
    private RichSelectionManager getRichSelectionManager() {
        return (RichSelectionManager)this.field_24269;
    }

    @Inject(method={"removeEmptyPages"}, at={@At(value="HEAD")})
    private void removeEmptyPages(CallbackInfo ci) {
        int lastIndex;
        for (int i = lastIndex = this.synchronizedPages.size() - 1; i >= 0 && this.synchronizedPages.get(i).isEmpty(); --i) {
            this.synchronizedPages.remove(i);
        }
    }

    @Redirect(method={"appendNewPage"}, at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z"))
    private boolean appendNewPage(List<String> page, Object empty) {
        InsertPageCommand command = new InsertPageCommand(this.synchronizedPages, this.synchronizedPages.size(), this);
        this.commandManager.execute(command);
        return true;
    }

    @Override
    public void scribble$onPageAdded(int pageAddedIndex) {
        this.field_2840 = pageAddedIndex;
        this.field_2837 = true;
        this.method_2413();
        this.method_27872();
    }

    @Override
    public void scribble$onPageRemoved(int pageRemovedIndex) {
        if (pageRemovedIndex < this.field_2840) {
            this.field_2840 = Math.max(0, pageRemovedIndex - 1);
        } else if (this.field_2840 >= this.synchronizedPages.size()) {
            this.field_2840 = Math.max(0, this.synchronizedPages.size() - 1);
        }
        this.field_2837 = true;
        this.method_2413();
        this.method_27872();
    }

    @Unique
    private void deletePage() {
        DeletePageCommand command = new DeletePageCommand(this.synchronizedPages, this.field_2840, this);
        this.commandManager.execute(command);
    }

    @Unique
    private void insertPage() {
        if (this.synchronizedPages.size() < 100) {
            InsertPageCommand command = new InsertPageCommand(this.synchronizedPages, this.field_2840, this);
            this.commandManager.execute(command);
        }
    }

    @Override
    public BookEditScreenMemento scribble$createMemento() {
        RichSelectionManager selectionManager = this.getRichSelectionManager();
        return new BookEditScreenMemento(this.field_2840, selectionManager.field_16453, selectionManager.field_16452, this.getCurrentPageText(), this.activeColor, Set.copyOf(this.activeModifiers));
    }

    @Override
    public void scribble$restore(BookEditScreenMemento memento) {
        this.field_2840 = memento.pageIndex();
        this.method_2413();
        this.method_27872();
        this.setPageText(memento.currentPageRichText());
        RichSelectionManager selectionManager = this.getRichSelectionManager();
        selectionManager.method_27548(memento.selectionStart(), memento.selectionEnd());
        this.activeColor = memento.color();
        this.activeModifiers = new HashSet<class_124>(memento.modifiers());
        this.invalidateFormattingButtons();
    }

    @Unique
    private void confirmOverwrite(Runnable callback) {
        if (!this.synchronizedPages.arePagesEmpty()) {
            if (this.field_22787 == null) {
                return;
            }
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    callback.run();
                }
                this.field_22787.method_1507((class_437)this);
            }, (class_2561)class_2561.method_43471((String)"text.scribble.overwrite_warning.title"), (class_2561)class_2561.method_43471((String)"text.scribble.overwrite_warning.description")));
        } else {
            callback.run();
        }
    }

    public void method_25419() {
        if (this.field_2837 && this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    super.method_25419();
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43471((String)"text.scribble.quit_without_saving.title"), (class_2561)class_2561.method_43471((String)"text.scribble.quit_without_saving.description")));
        } else {
            super.method_25419();
        }
    }

    @Unique
    private void saveTo(Path path) {
        try {
            BookFile bookFile = new BookFile(this.field_2826.method_7334().getName(), this.synchronizedPages.getRichPages());
            bookFile.write(path);
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not save book to file", (Throwable)e);
        }
    }

    @Unique
    private void loadFrom(Path path) {
        try {
            BookFile bookFile = BookFile.read(path);
            Collection<RichText> loadedPages = bookFile.pages().isEmpty() ? List.of(RichText.empty()) : bookFile.pages();
            this.synchronizedPages.clear();
            this.commandManager.clear();
            this.synchronizedPages.addAll(loadedPages);
            this.field_2840 = 0;
            this.field_2837 = true;
            this.method_2413();
            this.method_27872();
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not load book from file", (Throwable)e);
        }
    }

    @ModifyArg(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Ljava/util/function/Function;Lnet/minecraft/util/Identifier;IIFFIIII)V"), index=3)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.field_22790) + y;
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/BookEditScreen;addDrawableChild(Lnet/minecraft/client/gui/Element;)Lnet/minecraft/client/gui/Element;"))
    public <T extends class_364 & class_4068> T shiftButtonY(class_473 screen, T element) {
        if (element instanceof class_8021) {
            class_8021 widget = (class_8021)element;
            widget.method_46419(widget.method_46427() + Scribble.getBookScreenYOffset(this.field_22790));
        }
        return (T)this.method_37063(element);
    }

    @ModifyArg(method={"mouseClicked"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/BookEditScreen;screenPositionToAbsolutePosition(Lnet/minecraft/client/gui/screen/ingame/BookEditScreen$Position;)Lnet/minecraft/client/gui/screen/ingame/BookEditScreen$Position;"))
    public class_473.class_5234 shiftMouseClicks(class_473.class_5234 position) {
        return new class_473.class_5234(position.field_24281, position.field_24282 - Scribble.getBookScreenYOffset(this.field_22790));
    }

    @ModifyArg(method={"mouseDragged"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/BookEditScreen;screenPositionToAbsolutePosition(Lnet/minecraft/client/gui/screen/ingame/BookEditScreen$Position;)Lnet/minecraft/client/gui/screen/ingame/BookEditScreen$Position;"))
    public class_473.class_5234 shiftMouseDrags(class_473.class_5234 position) {
        return new class_473.class_5234(position.field_24281, position.field_24282 - Scribble.getBookScreenYOffset(this.field_22790));
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/Screen;render(Lnet/minecraft/client/gui/DrawContext;IIF)V", shift=At.Shift.AFTER)})
    public void translateRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, (float)Scribble.getBookScreenYOffset(this.field_22790), 0.0f);
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void popRender(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.method_51448().method_22909();
    }

    @Inject(method={"mouseDragged"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/BookEditScreen;getPageContent()Lnet/minecraft/client/gui/screen/ingame/BookEditScreen$PageContent;")}, cancellable=true)
    private void mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY, CallbackInfoReturnable<Boolean> cir) {
        if (mouseX < (double)(this.field_22789 - 152) / 2.0 || mouseX > (double)(this.field_22789 + 152) / 2.0) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"openNextPage"}, at={@At(value="HEAD")}, cancellable=true)
    public void openNextPage(CallbackInfo ci) {
        int lastPage = this.synchronizedPages.size() - 1;
        if (this.field_2840 < lastPage && class_437.method_25442()) {
            this.field_2840 = lastPage;
            this.method_2413();
            this.method_27872();
            ci.cancel();
        }
    }

    @Inject(method={"openPreviousPage"}, at={@At(value="HEAD")}, cancellable=true)
    public void openPreviousPage(CallbackInfo ci) {
        if (class_437.method_25442()) {
            this.field_2840 = 0;
            this.method_2413();
            this.method_27872();
            ci.cancel();
        }
    }

    @Redirect(method={"charTyped"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/SelectionManager;insert(Ljava/lang/String;)V"))
    private void charTypedEditMode(class_3728 instance, String string) {
        ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().method_16197(string));
        this.commandManager.execute(command);
    }

    @Inject(method={"keyPressedEditMode"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressedEditMode(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (BookEditScreenMixin.method_25441() && !BookEditScreenMixin.method_25443() && (keyCode == 67 || keyCode == 88)) {
            boolean shouldCopyFormatting = Scribble.CONFIG_MANAGER.getConfig().copyFormattingCodes && !BookEditScreenMixin.method_25442();
            String selectedText = this.getRichSelectionManager().getSelectedFormattedText();
            this.method_27584(shouldCopyFormatting ? selectedText : class_124.method_539((String)selectedText));
            if (keyCode == 88) {
                ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().method_27564(0));
                this.commandManager.execute(command);
            }
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.method_25441() && !BookEditScreenMixin.method_25443() && keyCode == 86) {
            String textToPaste = BookEditScreenMixin.method_25442() ? class_124.method_539((String)this.getRawClipboard()) : this.getRawClipboard();
            ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().method_16197(textToPaste));
            this.commandManager.execute(command);
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (!BookEditScreenMixin.method_25442() && BookEditScreenMixin.method_25441() && !BookEditScreenMixin.method_25443() && KeyboardUtil.isKey(keyCode, "Z")) {
            this.commandManager.tryUndo();
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.method_25441() && !BookEditScreenMixin.method_25443() && (BookEditScreenMixin.method_25442() && KeyboardUtil.isKey(keyCode, "Z") || !BookEditScreenMixin.method_25442() && KeyboardUtil.isKey(keyCode, "Y"))) {
            this.commandManager.tryRedo();
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (keyCode == 261 || keyCode == 259) {
            class_3728.class_7279 selectionType = class_437.method_25441() ? class_3728.class_7279.field_38309 : class_3728.class_7279.field_38308;
            int offset = keyCode == 261 ? 1 : -1;
            ActionCommand<BookEditScreenMemento> command = new ActionCommand<BookEditScreenMemento>(this, () -> this.getRichSelectionManager().method_42574(offset, selectionType));
            this.commandManager.execute(command);
            cir.setReturnValue((Object)true);
            cir.cancel();
            return;
        }
        if (BookEditScreenMixin.method_25441() && !BookEditScreenMixin.method_25442() && !BookEditScreenMixin.method_25443()) {
            if (keyCode == 66) {
                Optional.ofNullable(this.boldButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 73) {
                Optional.ofNullable(this.italicButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 85) {
                Optional.ofNullable(this.underlineButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 45) {
                Optional.ofNullable(this.strikethroughButton).ifPresent(ModifierButtonWidget::toggle);
            } else if (keyCode == 75) {
                Optional.ofNullable(this.obfuscatedButton).ifPresent(ModifierButtonWidget::toggle);
            } else {
                return;
            }
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @ModifyArg(method={"drawCursor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Ljava/lang/String;IIIZ)I"), index=4)
    private int modifyEndCursorColor(int constant) {
        return this.activeColor == null || this.activeColor.method_532() == null ? constant : this.activeColor.method_532();
    }

    @ModifyArg(method={"drawCursor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;fill(IIIII)V"), index=4)
    private int modifyLineCursorColor(int constant) {
        return this.modifyEndCursorColor(constant) | 0xFF000000;
    }

    protected void method_48263(class_8016 path) {
        this.method_48267();
    }

    @Overwrite
    private class_473.class_5233 method_27578() {
        class_473.class_5234 cursorPosition;
        boolean atEnd;
        RichText text = this.getCurrentPageText();
        String plainText = text.getPlainText();
        if (text.isEmpty()) {
            return RichPageContent.EMPTY;
        }
        int selectionStart = this.field_24269.method_16201();
        int selectionEnd = this.field_24269.method_16203();
        IntArrayList lineStarts = new IntArrayList();
        ArrayList lines = new ArrayList();
        MutableBoolean endsWithNewline = new MutableBoolean();
        class_5225 textHandler = this.field_22793.method_27527();
        MutableInt lineNumber = new MutableInt();
        MutableInt charNumber = new MutableInt();
        textHandler.method_29971((class_5348)text, 114, class_2583.field_24360, (arg_0, arg_1) -> this.lambda$createPageContent$34(lineNumber, charNumber, plainText, endsWithNewline, (IntList)lineStarts, lines, arg_0, arg_1));
        int[] lineStartsArray = lineStarts.toIntArray();
        boolean bl = atEnd = selectionStart == plainText.length();
        if (atEnd && endsWithNewline.isTrue()) {
            cursorPosition = new class_473.class_5234(0, lines.size() * 9);
        } else {
            int i = BookEditScreenMixin.method_27591(lineStartsArray, selectionStart);
            int width = this.field_22793.method_27525((class_5348)text.subText(lineStartsArray[i], selectionStart));
            cursorPosition = new class_473.class_5234(width, i * 9);
        }
        ArrayList selectionRectangles = Lists.newArrayList();
        if (selectionStart != selectionEnd) {
            int endLine;
            int selStart = Math.min(selectionStart, selectionEnd);
            int selEnd = Math.max(selectionStart, selectionEnd);
            int startLine = BookEditScreenMixin.method_27591(lineStartsArray, selStart);
            if (startLine == (endLine = BookEditScreenMixin.method_27591(lineStartsArray, selEnd))) {
                int y = startLine * 9;
                int lineStart = lineStartsArray[startLine];
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, selStart, selEnd, y, lineStart));
            } else {
                int lineEnd = startLine + 1 > lineStartsArray.length ? plainText.length() : lineStartsArray[startLine + 1];
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, selStart, lineEnd, startLine * 9, lineStartsArray[startLine]));
                for (int i = startLine + 1; i < endLine; ++i) {
                    int y = i * 9;
                    int s = (int)textHandler.method_27488(((RichPageContent.Line)((Object)lines.get(i))).getStringVisitable());
                    selectionRectangles.add(this.method_27583(new class_473.class_5234(0, y), new class_473.class_5234(s, y + 9)));
                }
                selectionRectangles.add(this.getSelectionRectangle(text, textHandler, lineStartsArray[endLine], selEnd, endLine * 9, lineStartsArray[endLine]));
            }
        }
        return new RichPageContent(text, cursorPosition, atEnd, lineStartsArray, lines.toArray(new class_473.class_475[0]), selectionRectangles.toArray(new class_768[0]));
    }

    private /* synthetic */ void lambda$createPageContent$34(MutableInt lineNumber, MutableInt charNumber, String plainText, MutableBoolean endsWithNewline, IntList lineStarts, List lines, class_5348 stringVisitable, Boolean continued) {
        String string = stringVisitable.getString();
        int length = string.length();
        int i = lineNumber.getAndIncrement();
        int start = charNumber.getValue();
        boolean newline = false;
        if (plainText.length() > start + length) {
            char lastChar = plainText.charAt(start + length);
            if (lastChar == '\n') {
                newline = true;
                ++length;
            } else if (lastChar == ' ') {
                ++length;
            }
        }
        endsWithNewline.setValue(newline);
        charNumber.add(length);
        int y = i * 9;
        class_473.class_5234 position = this.method_27590(new class_473.class_5234(0, y));
        lineStarts.add(start);
        lines.add(new RichPageContent.Line(stringVisitable, position.field_24281, position.field_24282));
    }
}

