/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history.command;

import me.chrr.scribble.book.RichText;
import me.chrr.scribble.book.SynchronizedPageList;
import me.chrr.scribble.history.command.Command;
import me.chrr.scribble.history.command.PagesListener;

public class InsertPageCommand
implements Command {
    private final SynchronizedPageList pages;
    private final int index;
    private final PagesListener pagesListener;

    public InsertPageCommand(SynchronizedPageList pages, int index, PagesListener pagesListener) {
        if (index < 0 || index > pages.size()) {
            throw new IllegalArgumentException("Insert page index is out of pages range");
        }
        this.pages = pages;
        this.index = index;
        this.pagesListener = pagesListener;
    }

    @Override
    public boolean execute() {
        this.pages.add(this.index, RichText.empty());
        this.pagesListener.scribble$onPageAdded(this.index);
        return true;
    }

    @Override
    public boolean rollback() {
        this.pages.remove(this.index);
        this.pagesListener.scribble$onPageRemoved(this.index);
        return true;
    }
}

