/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.chrr.scribble.book.RichText;
import org.jetbrains.annotations.NotNull;

public class SynchronizedPageList {
    private final List<RichText> richPages;
    private List<String> pages;

    private static List<RichText> createRichPages(List<String> pages) {
        return pages.stream().map(RichText::fromFormattedString).toList();
    }

    public SynchronizedPageList(List<String> pages, List<RichText> richPages) {
        this.pages = pages;
        this.richPages = richPages;
    }

    public SynchronizedPageList() {
        this(new ArrayList<String>(), new ArrayList<RichText>());
    }

    public void populate(List<String> pages) {
        this.pages = pages;
        this.richPages.clear();
        this.richPages.addAll(SynchronizedPageList.createRichPages(pages));
    }

    public RichText set(int index, RichText richText) {
        RichText result = this.richPages.set(index, richText);
        this.pages.set(index, richText.getAsFormattedString());
        return result;
    }

    public boolean add(RichText richText) {
        this.richPages.add(richText);
        this.pages.add(richText.getAsFormattedString());
        return true;
    }

    public void add(int index, RichText richText) {
        this.richPages.add(index, richText);
        this.pages.add(index, richText.getAsFormattedString());
    }

    public boolean addAll(@NotNull Collection<? extends RichText> collection) {
        boolean result = this.richPages.addAll(collection);
        collection.forEach(richText -> this.pages.add(richText.getAsFormattedString()));
        return result;
    }

    public RichText remove(int index) {
        RichText removed = this.richPages.remove(index);
        this.pages.remove(index);
        return removed;
    }

    public void clear() {
        this.richPages.clear();
        this.pages.clear();
    }

    public RichText get(int index) {
        return this.richPages.get(index);
    }

    public List<RichText> getRichPages() {
        return List.copyOf(this.richPages);
    }

    public List<String> getPages() {
        return List.copyOf(this.pages);
    }

    public int size() {
        return this.richPages.size();
    }

    public boolean isEmpty() {
        return this.richPages.isEmpty();
    }

    public boolean arePagesEmpty() {
        for (RichText page : this.richPages) {
            if (page.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

