/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util.interval_tree;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import net.caffeinemc.mods.sodium.client.util.interval_tree.Interval;
import net.caffeinemc.mods.sodium.client.util.interval_tree.TreeNode;

public class IntervalTree<T extends Comparable<? super T>>
extends AbstractSet<Interval<T>> {
    TreeNode<T> root;
    int size;

    @Override
    public boolean add(Interval<T> interval) {
        if (interval.isEmpty()) {
            return false;
        }
        int sizeBeforeOperation = this.size;
        this.root = TreeNode.addInterval(this, this.root, interval);
        return this.size == sizeBeforeOperation;
    }

    public Set<Interval<T>> query(Interval<T> interval) {
        HashSet<Interval<T>> result = new HashSet<Interval<T>>();
        if (this.root == null || interval.isEmpty()) {
            return result;
        }
        TreeNode<T> node = this.root;
        while (node != null) {
            if (interval.contains(node.midpoint)) {
                result.addAll(node.increasing);
                TreeNode.rangeQueryLeft(node.left, interval, result);
                TreeNode.rangeQueryRight(node.right, interval, result);
                break;
            }
            if (interval.isLeftOf(node.midpoint)) {
                for (Interval next : node.increasing) {
                    if (!interval.intersects(next)) break;
                    result.add(next);
                }
                node = node.left;
                continue;
            }
            for (Interval next : node.decreasing) {
                if (!interval.intersects(next)) break;
                result.add(next);
            }
            node = node.right;
        }
        return result;
    }

    public boolean remove(Interval<T> interval) {
        if (interval.isEmpty() || this.root == null) {
            return false;
        }
        int sizeBeforeOperation = this.size;
        this.root = TreeNode.removeInterval(this, this.root, interval);
        return this.size == sizeBeforeOperation;
    }

    @Override
    public Iterator<Interval<T>> iterator() {
        if (this.root == null) {
            return Collections.emptyIterator();
        }
        final TreeNode.TreeNodeIterator it = this.root.iterator();
        return new Iterator<Interval<T>>(){

            @Override
            public void remove() {
                if (it.currentNode.increasing.size() == 1) {
                    TreeNode node = IntervalTree.this.root = TreeNode.removeInterval(IntervalTree.this, IntervalTree.this.root, it.currentInterval);
                    it.stack = new Stack();
                    while (node != it.subtreeRoot) {
                        if (it.currentNode.midpoint.compareTo(node.midpoint) < 0) {
                            it.stack.push(node);
                            node = node.left;
                            continue;
                        }
                        node = node.right;
                    }
                } else {
                    it.remove();
                }
            }

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Interval<T> next() {
                return it.next();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = null;
    }

    @Override
    public boolean contains(Object o) {
        if (this.root == null || o == null) {
            return false;
        }
        if (!(o instanceof Interval)) {
            return false;
        }
        Interval query = (Interval)o;
        TreeNode<T> node = this.root;
        while (node != null) {
            if (query.contains(node.midpoint)) {
                return node.increasing.contains(query);
            }
            if (query.isLeftOf(node.midpoint)) {
                node = node.left;
                continue;
            }
            node = node.right;
        }
        return false;
    }
}

