/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import java.util.List;
import journeymap.api.v2.client.ui.component.LayeredScreen;
import journeymap.client.JourneymapClient;
import journeymap.client.log.JMLogger;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.ClientOptionsManager;
import journeymap.client.ui.option.MinimapOptions;
import journeymap.client.ui.option.OptionScreen;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class ScreenEventHandler {
    static final List<String> BLACK_LISTED_SCREENS = new ArrayList<String>();
    boolean clicked = false;
    boolean didDrag = false;
    static ScreenEventHandler instance;

    private ScreenEventHandler() {
    }

    public static ScreenEventHandler getInstance() {
        if (instance == null) {
            instance = new ScreenEventHandler();
        }
        return instance;
    }

    public void onScreenPreRender(class_437 screen, class_332 graphics, int mouseX, int mouseY) {
        if (JourneymapClient.getInstance() != null && JourneymapClient.getInstance().getCoreProperties() != null && JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().getCoreProperties().allowMiniMapBehindScreens.get().booleanValue()) {
            try {
                boolean preview;
                boolean bl = preview = screen instanceof ClientOptionsManager && ((ClientOptionsManager)screen).previewMiniMap();
                if (this.allowableDrawScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.isMiniMapEnabled()) {
                    graphics.method_51448().method_22903();
                    MiniMap miniMap = UIManager.INSTANCE.getMiniMap();
                    miniMap.drawMap(graphics, true);
                    graphics.method_51448().method_22909();
                } else if (!preview) {
                    this.clicked = false;
                }
            }
            catch (Throwable t) {
                JMLogger.throwLogOnce("Unexpected error during onScreenPreRender: " + String.valueOf(t), t);
            }
        }
    }

    public boolean onScreenMousePressedEvent(class_437 screen, double mouseX, double mouseY, int button) {
        if (JourneymapClient.getInstance().enabled() && !this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.clicked = UIManager.INSTANCE.getMiniMap().mouseClicked(mouseX, mouseY, 0);
            return this.clicked;
        }
        return false;
    }

    public boolean onScreenMouseDraggedEvent(class_437 screen, double mouseX, double mouseY, double dragX, double dragY, int mouseButton) {
        if (JourneymapClient.getInstance().enabled() && this.clicked && this.allowableDragScreens(screen) && JourneymapClient.getInstance().isMapping().booleanValue()) {
            this.didDrag = UIManager.INSTANCE.getMiniMap().mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
            return this.didDrag;
        }
        return false;
    }

    public boolean onScreenMouseReleasedEvent(class_437 screen, double mouseX, double mouseY, int button) {
        if (JourneymapClient.getInstance().enabled() && UIManager.INSTANCE.getMiniMap() != null && UIManager.INSTANCE.getMiniMap().mouseReleased(mouseX, mouseY, button)) {
            this.clicked = false;
            return true;
        }
        return false;
    }

    public void onScreenClosedEvent(class_437 screen) {
        if (JourneymapClient.getInstance().enabled() && JourneymapClient.getInstance().isMapping().booleanValue() && UIManager.INSTANCE.getMiniMap() != null) {
            UIManager.INSTANCE.getMiniMap().mouseReleased(0.0, 0.0, 0);
            this.clicked = false;
            this.didDrag = false;
        }
    }

    private boolean allowableDragScreens(class_437 screen) {
        return screen instanceof ClientOptionsManager;
    }

    private boolean allowableDrawScreens(class_437 screen) {
        if (screen instanceof LayeredScreen) {
            LayeredScreen layeredScreen = (LayeredScreen)screen;
            return this.allowableDrawScreens(layeredScreen.getBackgroundScreen());
        }
        return !(screen instanceof Fullscreen) && !(screen instanceof MinimapOptions) && !(screen instanceof OptionScreen) && !(screen instanceof class_408) && !this.modScreens(screen);
    }

    private boolean modScreens(class_437 screen) {
        return BLACK_LISTED_SCREENS.contains(screen.getClass().getSimpleName()) || BLACK_LISTED_SCREENS.contains(screen.getClass().getName());
    }

    static {
        BLACK_LISTED_SCREENS.add("com.cobblemon.mod.common.client.gui.battle.BattleGUI");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.TitleScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.worldselection.SelectWorldScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.LevelLoadingScreen");
        BLACK_LISTED_SCREENS.add("net.minecraft.client.gui.screens.GenericMessageScreen");
    }
}

