/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client;

import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.CtmLoader;
import me.pepperbell.continuity.api.client.CtmLoaderRegistry;
import me.pepperbell.continuity.api.client.CtmProperties;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.BaseCachingPredicates;
import me.pepperbell.continuity.client.processor.CompactCtmQuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.TopQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.SimpleOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.StandardOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.CtmSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.HorizontalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.HorizontalVerticalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RandomSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RepeatSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.VerticalHorizontalSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.VerticalSpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.ConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.OrientedConnectingCtmProperties;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.properties.RandomCtmProperties;
import me.pepperbell.continuity.client.properties.RepeatCtmProperties;
import me.pepperbell.continuity.client.properties.TileAmountValidator;
import me.pepperbell.continuity.client.properties.overlay.BaseOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.OrientedConnectingOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.RandomOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.RepeatOverlayCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCtmProperties;
import me.pepperbell.continuity.client.resource.CustomBlockLayers;
import me.pepperbell.continuity.client.resource.ModelWrappingHandler;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuityClient
implements ClientModInitializer {
    public static final String ID = "continuity";
    public static final String NAME = "Continuity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Continuity");

    public void onInitializeClient() {
        ProcessingDataKeyRegistryImpl.INSTANCE.init();
        BiomeHolderManager.init();
        ProcessingDataKeys.init();
        ModelWrappingHandler.init();
        RenderUtil.ReloadListener.init();
        CustomBlockLayers.ReloadListener.init();
        FabricLoader.getInstance().getModContainer(ID).ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ContinuityClient.asId("default"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcePack.continuity.default.name"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ContinuityClient.asId("glass_pane_culling_fix"), (ModContainer)container, (class_2561)class_2561.method_43471((String)"resourcePack.continuity.glass_pane_culling_fix.name"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
        CtmLoaderRegistry registry = CtmLoaderRegistry.get();
        CtmLoader<BaseCtmProperties> loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.AtLeast(47), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new CtmSpriteProvider.Factory()));
        registry.registerLoader("ctm", loader);
        registry.registerLoader("glass", loader);
        loader = ContinuityClient.createLoader(CompactConnectingCtmProperties::new, new TileAmountValidator.AtLeast(5), new CompactCtmQuadProcessor.Factory(), false);
        registry.registerLoader("ctm_compact", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalSpriteProvider.Factory()));
        registry.registerLoader("horizontal", loader);
        registry.registerLoader("bookshelf", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalSpriteProvider.Factory()));
        registry.registerLoader("vertical", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalVerticalSpriteProvider.Factory()));
        registry.registerLoader("horizontal+vertical", loader);
        registry.registerLoader("h+v", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalHorizontalSpriteProvider.Factory()));
        registry.registerLoader("vertical+horizontal", loader);
        registry.registerLoader("v+h", loader);
        loader = ContinuityClient.createLoader(ConnectingCtmProperties::new, new TileAmountValidator.Exactly(1), new TopQuadProcessor.Factory());
        registry.registerLoader("top", loader);
        loader = ContinuityClient.createLoader(RandomCtmProperties::new, new SimpleQuadProcessor.Factory<RandomCtmProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("random", loader);
        loader = ContinuityClient.createLoader(RepeatCtmProperties::new, new RepeatCtmProperties.Validator(), new SimpleQuadProcessor.Factory<RepeatCtmProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("repeat", loader);
        loader = ContinuityClient.createLoader(BaseCtmProperties::new, new TileAmountValidator.Exactly(1), new SimpleQuadProcessor.Factory<BaseCtmProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("fixed", loader);
        loader = ContinuityClient.createLoader(StandardOverlayCtmProperties::new, new TileAmountValidator.AtLeast(17), new StandardOverlayQuadProcessor.Factory());
        registry.registerLoader("overlay", loader);
        loader = ContinuityClient.createLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.AtLeast(47), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new CtmSpriteProvider.Factory()));
        registry.registerLoader("overlay_ctm", loader);
        loader = ContinuityClient.createLoader(RandomOverlayCtmProperties::new, new SimpleOverlayQuadProcessor.Factory<RandomCtmProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("overlay_random", loader);
        loader = ContinuityClient.createLoader(RepeatOverlayCtmProperties::new, new RepeatCtmProperties.Validator(), new SimpleOverlayQuadProcessor.Factory<RepeatCtmProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("overlay_repeat", loader);
        loader = ContinuityClient.createLoader(BaseOverlayCtmProperties::new, new TileAmountValidator.Exactly(1), new SimpleOverlayQuadProcessor.Factory<BaseCtmProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("overlay_fixed", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalSpriteProvider.Factory()));
        registry.registerLoader("overlay_horizontal", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(4), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalSpriteProvider.Factory()));
        registry.registerLoader("overlay_vertical", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new HorizontalVerticalSpriteProvider.Factory()));
        registry.registerLoader("overlay_horizontal+vertical", loader);
        registry.registerLoader("overlay_h+v", loader);
        loader = ContinuityClient.createCustomLoader(OrientedConnectingOverlayCtmProperties::new, new TileAmountValidator.Exactly(7), new SimpleOverlayQuadProcessor.Factory<OrientedConnectingCtmProperties>(new VerticalHorizontalSpriteProvider.Factory()));
        registry.registerLoader("overlay_vertical+horizontal", loader);
        registry.registerLoader("overlay_v+h", loader);
    }

    private static <T extends CtmProperties> CtmLoader<T> createLoader(final CtmProperties.Factory<T> propertiesFactory, final QuadProcessor.Factory<T> processorFactory, final CachingPredicates.Factory<T> predicatesFactory) {
        return new CtmLoader<T>(){

            @Override
            public CtmProperties.Factory<T> getPropertiesFactory() {
                return propertiesFactory;
            }

            @Override
            public QuadProcessor.Factory<T> getProcessorFactory() {
                return processorFactory;
            }

            @Override
            public CachingPredicates.Factory<T> getPredicatesFactory() {
                return predicatesFactory;
            }
        };
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(ContinuityClient.wrapWithOptifineOnlyCheck(TileAmountValidator.wrapFactory(BaseCtmProperties.wrapFactory(propertiesFactory), validator)), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createLoader(propertiesFactory, validator, processorFactory, true);
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(ContinuityClient.wrapWithOptifineOnlyCheck(BaseCtmProperties.wrapFactory(propertiesFactory)), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createLoader(CtmProperties.Factory<T> propertiesFactory, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createLoader(propertiesFactory, processorFactory, true);
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createCustomLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory, boolean isValidForMultipass) {
        return ContinuityClient.createLoader(TileAmountValidator.wrapFactory(BaseCtmProperties.wrapFactory(propertiesFactory), validator), processorFactory, new BaseCachingPredicates.Factory(isValidForMultipass));
    }

    private static <T extends BaseCtmProperties> CtmLoader<T> createCustomLoader(CtmProperties.Factory<T> propertiesFactory, TileAmountValidator<T> validator, QuadProcessor.Factory<T> processorFactory) {
        return ContinuityClient.createCustomLoader(propertiesFactory, validator, processorFactory, true);
    }

    private static <T extends CtmProperties> CtmProperties.Factory<T> wrapWithOptifineOnlyCheck(CtmProperties.Factory<T> factory) {
        return (properties, resourceId, pack, packPriority, resourceManager, method) -> {
            if (PropertiesParsingHelper.parseOptifineOnly(properties, resourceId)) {
                return null;
            }
            return factory.createProperties(properties, resourceId, pack, packPriority, resourceManager, method);
        };
    }

    public static class_2960 asId(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }
}

