/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.soundcontroller.config;

import com.bvengo.soundcontroller.VolumeData;
import com.bvengo.soundcontroller.config.ConfigParser;
import com.bvengo.soundcontroller.mixin.SoundSystemAccessor;
import java.util.HashMap;
import net.minecraft.class_1113;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_7923;

public class VolumeConfig {
    private static VolumeConfig instance;
    public static final int CONFIG_VERSION = 4;
    private final HashMap<class_2960, VolumeData> soundVolumes = new HashMap();
    public boolean subtitlesEnabled = false;

    private VolumeConfig() {
        ConfigParser.loadConfig(this);
        this.updateVolumes();
        ConfigParser.saveConfig(this);
    }

    public static VolumeConfig getInstance() {
        if (instance == null) {
            instance = new VolumeConfig();
        }
        return instance;
    }

    public void save() {
        ConfigParser.saveConfig(this);
    }

    private void updateVolumes() {
        for (class_3414 soundEvent : class_7923.field_41172) {
            if (soundEvent == class_3417.field_42593) continue;
            class_2960 soundId = soundEvent.comp_3319();
            this.soundVolumes.putIfAbsent(soundId, new VolumeData(soundId));
        }
    }

    public HashMap<class_2960, VolumeData> getVolumes() {
        return this.soundVolumes;
    }

    public VolumeData getVolumeData(class_2960 soundId) {
        return this.soundVolumes.getOrDefault(soundId, new VolumeData(soundId));
    }

    public float getAdjustedVolume(class_1113 sound, SoundSystemAccessor soundSystem) {
        VolumeData volumeData = this.getVolumeData(sound.method_4775());
        return volumeData.getAdjustedVolume(sound, soundSystem).floatValue();
    }

    public boolean areSubtitlesEnabled() {
        return this.subtitlesEnabled;
    }

    public void toggleSubtitles() {
        this.subtitlesEnabled = !this.subtitlesEnabled;
    }
}

