/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.soundcontroller.config;

import com.bvengo.soundcontroller.SoundController;
import com.bvengo.soundcontroller.VolumeData;
import com.bvengo.soundcontroller.config.VolumeConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;

public class ConfigParser {
    private static final File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "soundcontroller.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadConfig(VolumeConfig config) {
        if (!file.exists()) {
            SoundController.LOGGER.info("Config file not found. Creating a new one.");
            ConfigParser.buildEmptyConfig();
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject == null) {
                SoundController.LOGGER.error("Config file is empty, creating a new one.");
                ConfigParser.buildEmptyConfig();
                return;
            }
            ConfigParser.parseConfig(config, jsonObject);
        }
        catch (Exception e) {
            SoundController.LOGGER.error("Error reading config file, creating a new one. Original error: ", (Throwable)e);
            ConfigParser.moveOldConfig();
            ConfigParser.buildEmptyConfig();
        }
    }

    public static void saveConfig(VolumeConfig config) {
        JsonObject jsonObject = ConfigParser.createJsonConfig(config);
        ConfigParser.saveToJsonFile(jsonObject);
    }

    private static JsonObject createJsonConfig(VolumeConfig config) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("version", (Number)4);
        jsonObject.addProperty("subtitlesEnabled", Boolean.valueOf(config.subtitlesEnabled));
        JsonArray sounds = new JsonArray();
        config.getVolumes().values().stream().filter(volumeData -> volumeData.getVolume().floatValue() != 1.0f).sorted(Comparator.comparing(v -> v.getId().toString())).forEach(volumeData -> {
            JsonObject soundObject = new JsonObject();
            soundObject.addProperty("soundId", volumeData.getId().toString());
            soundObject.addProperty("volume", (Number)volumeData.getVolume());
            sounds.add((JsonElement)soundObject);
        });
        jsonObject.add("sounds", (JsonElement)sounds);
        return jsonObject;
    }

    private static void saveToJsonFile(JsonObject jsonObject) {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (IOException e) {
            SoundController.LOGGER.error("Unable to save sound config to file.", (Throwable)e);
        }
    }

    private static void parseConfig(VolumeConfig config, JsonObject jsonObject) {
        int version;
        int n = version = jsonObject.has("version") ? jsonObject.get("version").getAsInt() : -1;
        if (version == -1) {
            String msg = "Config file does not have a version number. Trying to parse old un-versioned format.";
            SoundController.LOGGER.warn(msg);
            ConfigParser.parseConfigUnversioned(config, jsonObject);
            return;
        }
        if (version < 4 || version > 4) {
            String msg = "Version number invalid - must be between 4 and 4 (inclusive). Got " + version + " instead. Storing old config file with `old.` prefix, and initializing a new empty config file.";
            SoundController.LOGGER.error(msg);
            ConfigParser.moveOldConfig();
            ConfigParser.buildEmptyConfig();
            return;
        }
        ConfigParser.parseConfig4(config, jsonObject);
    }

    private static void moveOldConfig() {
        File oldFile = new File(file.getParentFile(), "old." + file.getName());
        if (file.renameTo(oldFile)) {
            SoundController.LOGGER.info("Renamed old config file to " + oldFile.getName());
        } else {
            SoundController.LOGGER.error("Failed to rename old config file.");
        }
    }

    private static void buildEmptyConfig() {
        JsonObject newConfig = new JsonObject();
        newConfig.addProperty("version", (Number)4);
        newConfig.add("sounds", (JsonElement)new JsonArray());
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((JsonElement)newConfig, (Appendable)writer);
        }
        catch (IOException e) {
            SoundController.LOGGER.error("Failed to create a new empty config file.", (Throwable)e);
        }
    }

    private static void addVolumeData(HashMap<class_2960, VolumeData> soundVolumes, String soundId, float volume) {
        class_2960 id = class_2960.method_12829((String)soundId);
        if (soundVolumes.containsKey(id)) {
            SoundController.LOGGER.warn("Duplicate sound ID found in config: {}. Taking first only.", (Object)soundId);
            return;
        }
        VolumeData volumeData = new VolumeData(id, volume);
        if (id != null) {
            soundVolumes.put(id, volumeData);
        } else {
            SoundController.LOGGER.warn("Invalid sound ID found in config: {}. Skipping.", (Object)soundId);
        }
    }

    private static void parseConfig4(VolumeConfig config, JsonObject jsonObject) {
        JsonElement subtitlesElement = jsonObject.get("subtitlesEnabled");
        if (subtitlesElement != null) {
            config.subtitlesEnabled = subtitlesElement.getAsBoolean();
        }
        HashMap<class_2960, VolumeData> soundVolumes = config.getVolumes();
        JsonArray sounds = jsonObject.getAsJsonArray("sounds");
        for (JsonElement soundElement : sounds) {
            JsonObject soundObject = soundElement.getAsJsonObject();
            String soundId = soundObject.get("soundId").getAsString();
            float volume = soundObject.get("volume").getAsFloat();
            ConfigParser.addVolumeData(soundVolumes, soundId, volume);
        }
        SoundController.LOGGER.info("Successfully loaded in configs.");
    }

    private static void parseConfigUnversioned(VolumeConfig config, JsonObject jsonObject) {
        HashMap<class_2960, VolumeData> soundVolumes = config.getVolumes();
        jsonObject.entrySet().forEach(entry -> {
            float volume;
            String soundId;
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonPrimitive()) {
                if (!element.getAsJsonPrimitive().isNumber()) {
                    String msg = "Unsupported config format for sound ID: " + key;
                    SoundController.LOGGER.error(msg);
                    throw new IllegalStateException(msg);
                }
                soundId = key;
                volume = element.getAsFloat();
            } else {
                JsonObject soundObject = element.getAsJsonObject();
                if (soundObject.has("id")) {
                    soundId = soundObject.get("id").getAsString();
                    volume = soundObject.get("volume").getAsFloat();
                } else {
                    if (!soundObject.has("soundId")) {
                        String msg = "Unsupported config format for sound ID: " + key;
                        SoundController.LOGGER.error(msg);
                        throw new IllegalStateException(msg);
                    }
                    soundId = soundObject.get("soundId").getAsString();
                    volume = soundObject.get("volume").getAsFloat();
                }
            }
            ConfigParser.addVolumeData(soundVolumes, soundId, volume);
        });
    }
}

