/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.threading;

import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.threading.DhThreadFactory;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreadPoolUtil {
    private static PriorityTaskPicker taskPicker;
    private static PriorityTaskPicker.Executor fileHandlerThreadPool;
    private static PriorityTaskPicker.Executor updatePropagatorThreadPool;
    public static final DhThreadFactory WORLD_GEN_THREAD_FACTORY;
    private static PriorityTaskPicker.Executor worldGenThreadPool;
    public static final String CLEANUP_THREAD_NAME = "Cleanup";
    private static final ThreadPoolExecutor cleanupThreadPool;
    public static final String BEACON_CULLING_THREAD_NAME = "Beacon Culling";
    private static ThreadPoolExecutor beaconCullingThreadPool;
    private static PriorityTaskPicker.Executor networkCompressionThreadPool;
    public static final String FULL_DATA_MIGRATION_THREAD_NAME = "Full Data Migration";
    private static ThreadPoolExecutor fullDataMigrationThreadPool;
    private static PriorityTaskPicker.Executor chunkToLodBuilderThreadPool;

    @Nullable
    public static PriorityTaskPicker.Executor getFileHandlerExecutor() {
        return fileHandlerThreadPool;
    }

    @Nullable
    public static PriorityTaskPicker.Executor getUpdatePropagatorExecutor() {
        return updatePropagatorThreadPool;
    }

    @Nullable
    public static PriorityTaskPicker.Executor getWorldGenExecutor() {
        return worldGenThreadPool;
    }

    @NotNull
    public static ThreadPoolExecutor getCleanupExecutor() {
        return cleanupThreadPool;
    }

    @Nullable
    public static ThreadPoolExecutor getBeaconCullingExecutor() {
        return beaconCullingThreadPool;
    }

    @Nullable
    public static PriorityTaskPicker.Executor getNetworkCompressionExecutor() {
        return networkCompressionThreadPool;
    }

    @Nullable
    public static ThreadPoolExecutor getFullDataMigrationExecutor() {
        return fullDataMigrationThreadPool;
    }

    @Nullable
    public static PriorityTaskPicker.Executor getChunkToLodBuilderExecutor() {
        return chunkToLodBuilderThreadPool;
    }

    public static void setupThreadPools() {
        if (taskPicker != null) {
            taskPicker.shutdown();
        }
        taskPicker = new PriorityTaskPicker();
        networkCompressionThreadPool = taskPicker.createExecutor();
        fileHandlerThreadPool = taskPicker.createExecutor();
        chunkToLodBuilderThreadPool = taskPicker.createExecutor();
        updatePropagatorThreadPool = taskPicker.createExecutor();
        worldGenThreadPool = taskPicker.createExecutor();
        if (beaconCullingThreadPool != null) {
            beaconCullingThreadPool.shutdown();
        }
        beaconCullingThreadPool = ThreadUtil.makeSingleThreadPool(BEACON_CULLING_THREAD_NAME);
        if (fullDataMigrationThreadPool != null) {
            fullDataMigrationThreadPool.shutdown();
        }
        fullDataMigrationThreadPool = ThreadUtil.makeSingleThreadPool(FULL_DATA_MIGRATION_THREAD_NAME);
    }

    public static void shutdownThreadPools() {
        taskPicker.shutdown();
        beaconCullingThreadPool.shutdown();
        fullDataMigrationThreadPool.shutdown();
    }

    static {
        WORLD_GEN_THREAD_FACTORY = new DhThreadFactory("World Gen", 1, false);
        cleanupThreadPool = ThreadUtil.makeSingleThreadPool(CLEANUP_THREAD_NAME);
    }
}

